#include <Wire.h>
#include <LiquidCrystal_I2C.h>

// Inisialisasi pin sensor TCS3200
const int S0 = 2;
const int S1 = 3;
const int S2 = 4;
const int S3 = 5;
const int OUT = 10;

// Inisialisasi pin LCD
const int LCD_ADDR = 0x27; // Alamat I2C LCD
const int LCD_COLS = 16; // Jumlah kolom LCD
const int LCD_ROWS = 2; // Jumlah baris LCD
LiquidCrystal_I2C lcd(LCD_ADDR, LCD_COLS, LCD_ROWS);

// Inisialisasi pin buzzer
const int BUZZER_PIN = 7;

// Variabel untuk menyimpan data warna
int redValue, greenValue, blueValue;

void setup() {
  pinMode(S0, OUTPUT);
  pinMode(S1, OUTPUT);
  pinMode(S2, OUTPUT);
  pinMode(S3, OUTPUT);
  pinMode(OUT, INPUT);
  
  lcd.begin(LCD_COLS, LCD_ROWS);
  lcd.clear();
  lcd.print("Deteksi Kematangan");
  lcd.setCursor(0, 1);
  lcd.print("Pepaya");
  
  pinMode(BUZZER_PIN, OUTPUT);
}

void loop() {
  // Mengatur resolusi output sensor
  digitalWrite(S0, LOW);
  digitalWrite(S1, HIGH);

  // Membaca nilai warna
  redValue = pulseIn(OUT, digitalRead(OUT) == HIGH ? LOW : HIGH);
  
  digitalWrite(S2, LOW);
  digitalWrite(S3, HIGH);

  // Membaca nilai warna
  blueValue = pulseIn(OUT, digitalRead(OUT) == HIGH ? LOW : HIGH);

  // Menampilkan nilai warna di layar LCD
  lcd.clear();
  lcd.print("Merah: ");
  lcd.print(redValue);
  lcd.setCursor(0, 1);
  lcd.print("Biru: ");
  lcd.print(blueValue);

  // Mengecek kematangan pepaya berdasarkan nilai warna
  if (redValue > 100 && blueValue < 100) {
    // Kematangan pepaya tercapai
    digitalWrite(BUZZER_PIN, HIGH);
    delay(1000);
    digitalWrite(BUZZER_PIN, LOW);
    delay(2000);
  } else {
    // Pepaya belum matang
    digitalWrite(BUZZER_PIN, LOW);
    delay(1000);
  }
}
